import { Link } from "react-router-dom";
export default function CarCard({ car }) {
  return (
     <Link to={`/cars/${car.id}`}>
    <div className="bg-white shadow-lg rounded-lg overflow-hidden hover:shadow-xl transition duration-300">
      {/* Car Image */}
      <img
        src={car.image}
        alt={car.name}
        className="w-full h-48 object-cover"
      />

      {/* Car Details */}
      <div className="p-4">
        <h3 className="text-lg font-semibold ">{car.name}</h3>
        <p className="text-gray-500 mb-2">{car.type}</p>
        <p className="text-yellow-500 font-bold">${car.price}/day</p>
        <div className="flex space-x-1 text-[10px] text-white mt-1"><p className="bg-red-600 px-2 ">promo</p><p className="bg-red-600 px-1">pre-order</p></div>
        <button className="bg-red-600 text-white p-3 w-full mt-2">view detail</button>
      </div>
    </div>
    </Link>
  );
}
