import { NavLink } from "react-router-dom";

export default function Navbar() {
  const navLinkClass = ({ isActive }) =>
    isActive
      ? "text-yellow-300 font-semibold"
      : "hover:text-yellow-200";

  return (
    <nav className="  flex justify-between items-center">
      <div className=""><img src="/Logo.png" className="w-48 h-12 " alt="" /></div>
      <ul className="flex space-x-6 text-lg font-bold p-4 ">
        <li>
          {/* Use `end` for root path */}
          <NavLink to="/" className={navLinkClass} end>
            Home
          </NavLink>
        </li>
        <li>
          <NavLink to="/cars" className={navLinkClass}>
            Cars
          </NavLink>
        </li>
        <li>
          <NavLink to="/host" className={navLinkClass}>
            Host
          </NavLink>
        </li>
        <li>
          <NavLink to="/about" className={navLinkClass}>
            About Us
          </NavLink>
         

        </li>
        <li>
             <NavLink to="/login" className={navLinkClass}>
           Login
          </NavLink>
        </li>
      </ul>
    </nav>
  );
}
