import React, { createContext, useState, useEffect } from 'react';
import axiosClient from '../api/axios';

export const AuthContext = createContext();

export const AuthProvider = ({ children }) => {
    const [user, setUser] = useState(null);
    const [loading, setLoading] = useState(true);

    useEffect(() => {
        checkAuth();
    }, []);

    const checkAuth = async () => {
        const token = localStorage.getItem('token');
        if (token) {
            try {
                const response = await axiosClient.get('/user');
                setUser(response.data);
            } catch (error) {
                localStorage.removeItem('token');
            }
        }
        setLoading(false);
    };

    const login = async (email, password) => {
        const response = await axiosClient.post('/login', { email, password });
        localStorage.setItem('token', response.data.data.token);
        setUser(response.data.data.user);
        return response.data.data.user;
    };

    const logout = async () => {
        await axiosClient.post('/logout');
        localStorage.removeItem('token');
        setUser(null);
    };

    const register = async (name, email, password, password_confirmation, role) => {
        const response = await axiosClient.post('/register', {
            name, email, password, password_confirmation, role
        });
        localStorage.setItem('token', response.data.data.token);
        setUser(response.data.data.user);
        return response.data.data.user;
    };

    return (
        <AuthContext.Provider value={{ user, login, logout, register, loading }}>
            {children}
        </AuthContext.Provider>
    );
};
