import React from "react";
import Sidebar from "./Sidebar"; // same folder
import { Routes, Route } from "react-router-dom";
import AdminCars from "./AdminCars"; 
import AddCar from "./AddCar";

function DashboardHome() {
  return <h2 className="text-2xl font-semibold">Welcome to Admin Dashboard</h2>;
}



function UsersPage() {
  return <h2 className="text-2xl font-semibold">Manage Users</h2>;
}

function SettingsPage() {
  return <h2 className="text-2xl font-semibold">Settings</h2>;
}

export default function AdminDashboard() {
  return (
    <div className="flex min-h-screen bg-gray-100">
      {/* Sidebar */}
      <Sidebar />

      {/* Main content */}
      <main className="flex-1 p-8">
        <Routes>
          <Route index element={<DashboardHome />} />
            <Route path="cars" element={<AdminCars />} /> 
          <Route path="users" element={<UsersPage />} />
          <Route path="settings" element={<SettingsPage />} />
          <Route path="cars/add" element={<AddCar />} />
         
        </Routes>
      </main>
    </div>
  );
}
