import { useState } from "react";
import CarCard from "../components/CarCard";
import carsData from "../Data";

export default function CarsPage() {
  const [selectedTypes, setSelectedTypes] = useState([]);
  const [selectedColors, setSelectedColors] = useState([]);
  const [selectedFuel, setSelectedFuel] = useState([]);
  const [priceRange, setPriceRange] = useState(0);

  const handleCheckbox = (value, list, setList) => {
    if (list.includes(value)) {
      setList(list.filter((item) => item !== value));
    } else {
      setList([...list, value]);
    }
  };

  const filteredCars = carsData.filter((car) => {
    const typeMatch = selectedTypes.length === 0 || selectedTypes.includes(car.type);
    const colorMatch = selectedColors.length === 0 || selectedColors.includes(car.color);
    const fuelMatch = selectedFuel.length === 0 || selectedFuel.includes(car.fuelType);
    const priceMatch = priceRange === 0 || car.price <= priceRange;
    return typeMatch && colorMatch && fuelMatch && priceMatch;
  });

  return (
    <div>
      <h1 className="text-3xl font-bold mb-6 text-center">Available Cars</h1>
    <div className="flex bg-gray-100 min-h-screen p-6">
      
      {/* Fixed / Sticky Search Panel */}
      <div className="w-64 mr-6">
        <div className="bg-white p-4 rounded-lg shadow-lg sticky top-6">
          <h2 className="text-xl font-bold mb-4">Filter Cars</h2>

          {/* Price Range */}
          <div className="mb-4">
            <label className="block mb-2 font-semibold">Max Price: ${priceRange}</label>
            <input
              type="range"
              min="0"
              max="200"
              value={priceRange}
              onChange={(e) => setPriceRange(parseInt(e.target.value))}
              className="w-full"
            />
          </div>

          {/* Car Type */}
          <div className="mb-4">
            <p className="font-semibold mb-2">Car Type</p>
            {["Sedan", "SUV", "Coupe", "Hatchback"].map((type) => (
              <label key={type} className="block mb-1">
                <input
                  type="checkbox"
                  className="mr-2"
                  checked={selectedTypes.includes(type)}
                  onChange={() => handleCheckbox(type, selectedTypes, setSelectedTypes)}
                />
                {type}
              </label>
            ))}
          </div>

          {/* Car Color */}
          <div className="mb-4">
            <p className="font-semibold mb-2">Color</p>
            {["White", "Black", "Red", "Blue", "Grey"].map((color) => (
              <label key={color} className="block mb-1">
                <input
                  type="checkbox"
                  className="mr-2"
                  checked={selectedColors.includes(color)}
                  onChange={() => handleCheckbox(color, selectedColors, setSelectedColors)}
                />
                {color}
              </label>
            ))}
          </div>

          {/* Fuel Type */}
          <div className="mb-4">
            <p className="font-semibold mb-2">Fuel Type</p>
            {["Petrol", "Diesel", "Electric"].map((fuel) => (
              <label key={fuel} className="block mb-1">
                <input
                  type="checkbox"
                  className="mr-2"
                  checked={selectedFuel.includes(fuel)}
                  onChange={() => handleCheckbox(fuel, selectedFuel, setSelectedFuel)}
                />
                {fuel}
              </label>
            ))}
          </div>
        </div>
      </div>

      {/* Main Content */}
      <div className="flex-1">
        
        {filteredCars.length === 0 ? (
          <p className="text-center text-gray-500">No cars found matching filters.</p>
        ) : (
          <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
            {filteredCars.map((car) => (
              <CarCard key={car.id} car={car} />
            ))}
          </div>
        )}
      </div>
    </div>
    </div>
  );
}
