import React, { useState, useContext } from 'react';
import { useNavigate } from 'react-router-dom';
import { AuthContext } from '../contexts/AuthContext';

const Login = () => {
    const [email, setEmail] = useState('');
    const [password, setPassword] = useState('');
    const [error, setError] = useState('');
    const { login } = useContext(AuthContext);
    const navigate = useNavigate();

    const handleSubmit = async (e) => {
        e.preventDefault();
        try {
            const user = await login(email, password);
            // Redirect based on role
            if (user.role === 'admin') {
                navigate('/admin/dashboard');
            } else if (user.role === 'vendor') {
                navigate('/vendor/dashboard');
            } else {
                navigate('/user/dashboard');
            }
        } catch (err) {
            setError('Invalid credentials');
        }
    };

    return (
        <div className=''>
            <h2>Login</h2>
            {error && <p style={{color: 'red'}}>{error}</p>}
            <div className='flex  gap-4 justify-center bg-stone-300 min-h-screen items-center' >
            <form onSubmit={handleSubmit} className='border p-6 rounded-lg bg-white shadow-md'>
                <input
                    type="email"
                    placeholder="Email"
                    value={email}
                    onChange={(e) => setEmail(e.target.value)}
                    className='border p-2 m-2 rounded-lg'
                    required
                /><br />
                <input
                    type="password"
                    placeholder="Password"
                    value={password}
                    onChange={(e) => setPassword(e.target.value)}
                    className='border p-2 m-2 rounded-lg'
                    required
                /><br />
                <button type="submit"className='bg-green-300 text-red-600 p-2 w-full rounded-xl mt-3' >Login</button>
            </form>
            </div>
        </div>
    );
};

export default Login;
