import React from "react";
import { NavLink, useNavigate } from "react-router-dom";
import { LayoutDashboard, Car, Users, Settings, LogOut } from "lucide-react";

export default function Sidebar() {
  const navigate = useNavigate();

  const handleLogout = () => {
    // Optional: clear tokens
    localStorage.removeItem("token");
    navigate("/login");
  };

  const linkClass = ({ isActive }) =>
    `flex items-center gap-3 p-3 rounded-lg transition ${
      isActive ? "bg-blue-600 text-white" : "text-gray-700 hover:bg-gray-200"
    }`;

  return (
    <aside className="w-64 bg-white shadow-md flex flex-col justify-between">
      <div>
        <div className="p-6 text-2xl font-bold text-blue-600">Admin</div>

        <nav className="flex flex-col gap-1 px-4">
          <NavLink end to="/admin/dashboard" className={linkClass}>
            <LayoutDashboard size={20} /> Dashboard
          </NavLink>
          <NavLink to="/admin/dashboard/cars" className={linkClass}>
            <Car size={20} /> Cars
            </NavLink>
          <NavLink to="/admin/dashboard/users" className={linkClass}>
            <Users size={20} /> Users
          </NavLink>
          <NavLink to="/admin/dashboard/settings" className={linkClass}>
            <Settings size={20} /> Settings
          </NavLink>
        </nav>
      </div>

      <div className="p-4 border-t">
        <button
          onClick={handleLogout}
          className="flex items-center gap-3 text-red-600 hover:text-red-700 w-full"
        >
          <LogOut size={20} /> Logout
        </button>
      </div>
    </aside>
  );
}
