<?php
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\API\AuthController;
use App\Http\Controllers\API\CarController;

// Public routes
Route::post('register', [AuthController::class, 'register']);
Route::post('login', [AuthController::class, 'login']);


// Protected routes
Route::middleware('auth:sanctum')->group(function () {
    Route::get('user', [AuthController::class, 'user']);
    Route::post('logout', [AuthController::class, 'logout']);
    
    // User dashboard routes
    Route::middleware('role:user')->prefix('user')->group(function () {
        Route::get('dashboard', function () {
            return response()->json(['message' => 'User Dashboard']);
        });
    });

    // Vendor dashboard routes
    Route::middleware('role:vendor')->prefix('vendor')->group(function () {
        Route::get('dashboard', function () {
            return response()->json(['message' => 'Vendor Dashboard']);
        });
    });

    // Admin dashboard routes
    Route::middleware('role:admin')->prefix('admin')->group(function () {
        Route::get('dashboard', function () {
            return response()->json(['message' => 'Admin Dashboard']);
        });
        Route::post('/cars', [CarController::class, 'store']);
    });
});
